<?php

namespace SpondonIt\Service\Repositories;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Storage;
use Illuminate\Validation\ValidationException;

class InitRepository {

    public function init() {
        config(['app.verifier' => 'http://auth.uxseven.com']);
        config(['app.signature' => 'eyJpdiI6Im9oMWU5Z0NoSGVwVzdmQlphaVBvd1E9PSIsInZhbHVlIjoiUURhZmpubkNBUVB6b0ZPck1v']);
    }

    public function checkDatabase(){

        try {
            if (!Storage::has('settings.json')) {
                DB::connection()->getPdo();
                if (!Schema::hasTable(config('spondonit.settings_table')) || !Schema::hasTable('users')){
                    return false;
                }
            }
        } catch(\Exception $e){
            $error = $e->getCode();
            if($error == 2002){
                 abort(403, 'No connection could be made because the target machine actively refused it');
            } else if($error == 1045){
                $c = Storage::exists('.app_installed') && Storage::get('.app_installed');
                if($c){
                     abort(403, 'Access denied for user. Please check your database username and password.');
                }

            }
        }

        return true;
    }

    public function check() {
        Storage::put('.access_log', date('Y-m-d'));
    }

     public function product() {
        $product['purchase_code'] = config('system.hidden_field');
        $product['email'] = config('system.hidden_field');
        $product['access_code'] = config('system.hidden_field');
        $product['checksum'] = config('system.hidden_field');
        $is_downloaded = 0;
        $about = file_get_contents(config('app.verifier') . '/about');
        $update_tips = file_get_contents(config('app.verifier') . '/update-tips');
        $support_tips = file_get_contents(config('app.verifier') . '/support-tips');
        return compact('about', 'product', 'update_tips', 'support_tips', 'is_downloaded');
    }

}
