<?php $__env->startSection('mainContent'); ?>

    <section class="admin-visitor-area up_admin_visitor">
        <div class="container-fluid p-0">

            <div class="row">
                <div class="col-lg-12 col-md-6">
                    <div class="main-title">
                        <h3 class="mb-30"><?php echo e($model->title); ?></h3>
                    </div>
                </div>

                <div class="col-lg-12 d-print-none">

                    <?php if($model->judgement_status=='Open' OR $model->judgement_status=='Reopen'): ?>
                        <?php if(permissionCheck('date.store')): ?>
                            <a href="<?php echo e(route('date.create', ['case' => $model->id])); ?>"
                               class="primary-btn small fix-gr-bg"><i
                                    class="ti-calendar mr-2"></i><?php echo e(__('case.New Date')); ?></a>
                        <?php endif; ?>
                        <?php if(permissionCheck('putlist.store')): ?>
                            <a href="<?php echo e(route('putlist.create', ['case' => $model->id])); ?>"
                               class="primary-btn small fix-gr-bg"><i
                                    class="ti-calendar mr-2"></i><?php echo e(__('case.New Put Up Date')); ?></a>
                        <?php endif; ?>
                        <?php if(permissionCheck('lobbying.store')): ?>
                            <a href="<?php echo e(route('lobbying.create', ['case' => $model->id])); ?>"
                               class="primary-btn small fix-gr-bg"><i
                                    class="ti-calendar mr-2"></i><?php echo e(__('case.New Lobbying Date')); ?></a>
                        <?php endif; ?>
                        <?php if(permissionCheck('judgement.store')): ?>
                            <a href="<?php echo e(route('judgement.create', ['case' => $model->id])); ?>"
                               class="primary-btn small fix-gr-bg"><i
                                    class="ti-calendar mr-2"></i><?php echo e(__('case.New Judgement Date')); ?></a>
                        <?php endif; ?>

                    <?php endif; ?>
                    <?php if($model->judgement_status=='Judgement'): ?>
                        <?php if(permissionCheck('judgement.store')): ?>
                            <a href="<?php echo e(route('judgement.reopen', ['case' => $model->id])); ?>"
                               class="primary-btn small fix-gr-bg"><i
                                    class="ti-calendar mr-2"></i><?php echo e(__('case.Re-open')); ?></a>
                        <?php endif; ?>
                        <?php if(permissionCheck('judgement.store')): ?>
                            <a href="<?php echo e(route('judgement.close', ['case' => $model->id])); ?>"
                               class="primary-btn small fix-gr-bg"><i
                                    class="ti-calendar mr-2"></i><?php echo e(__('case.Close')); ?></a>
                        <?php endif; ?>

                    <?php endif; ?>

                    <a class="primary-btn small fix-gr-bg print_window"
                       href="<?php echo e(route('case.show', [$model->id, 'print' => true])); ?>" target="_blank"><i
                            class="ti-printer mr-2"></i>
                        <?php echo e(__('case.Print')); ?>

                    </a>
                    <a class="primary-btn small fix-gr-bg " href="<?php echo e(route('file.index', ['case' => $model->id])); ?>"><i
                            class="ti-file mr-2"></i>
                        <?php echo e(__('case.File')); ?>

                    </a>


                </div>
            </div>


            <div class="row">
                <div class="col-lg-8 mt-25">

                    <div class="row">
                        <div class="col-lg-12">

                            <?php $__currentLoopData = $model->hearing_dates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <?php if($date->type == 'lobbying'): ?>
                                    <div class="student-meta-box mb-20">
                                        <div class="white-box student-details pt-2 pb-3">
                                            <div class="single-meta">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div class="name mr-1">
                                                        <h3 class="mb-0"><?php echo e(formatDate($date->date)); ?> </h3>
                                                    </div>
                                                    <div class="value">
                                                        <?php if(permissionCheck('case.index') and $date->date >= date('Y-m-d')): ?>
                                                            <a style="cursor: pointer;"

                                                               href="<?php echo e(route('date.send_mail', ['case' => $model->id, 'date' => $date->id])); ?>"
                                                               class="primary-btn small fix-gr-bg"><?php echo e(__('case.Send Mail')); ?></a>
                                                        <?php endif; ?>
                                                        <?php if(permissionCheck('lobbying.edit')): ?>
                                                            <span style="cursor: pointer;"
                                                                  data-container="file_modal"
                                                                  data-href="<?php echo e(route('file.create', ['case' => $model->id, 'date' => $date->id])); ?>"
                                                                  class="primary-btn small fix-gr-bg btn-modal"><?php echo e(__('case.Add File')); ?></span>
                                                        <?php endif; ?>
                                                        <?php if(permissionCheck('lobbying.edit')): ?>
                                                            <a href="<?php echo e(route('lobbying.edit', [$date->id, 'case' => $model->id])); ?>"
                                                               class="primary-btn small fix-gr-bg"><?php echo e(__('common.Edit')); ?></a>
                                                        <?php endif; ?>
                                                        <?php if(permissionCheck('lobbying.destroy')): ?>
                                                            <span style="cursor: pointer;"
                                                                  data-url="<?php echo e(route('lobbying.destroy', $date->id)); ?>"
                                                                  id="delete_item"
                                                                  class="primary-btn small fix-gr-bg"><?php echo e(__('common.Delete')); ?></span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="single-meta">
                                                <div class="d-flex">
                                                    <div class="name mr-1">
                                                        <?php echo e(__('case.Case Type')); ?> :
                                                    </div>
                                                    <div class="value">
                                                        <?php echo e(__('case.Lobbying')); ?>

                                                    </div>
                                                </div>
                                            </div>
                                            <?php if(moduleStatusCheck('CustomField') and $date->customFields): ?>
                                                <?php if ($__env->exists('customfield::details.show', ['customFields' => $date->customFields, 'file' => 'single_meta'])) echo $__env->make('customfield::details.show', ['customFields' => $date->customFields, 'file' => 'single_meta'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php endif; ?>

                                            <div class="single-meta">
                                                <div class="text-left">
                                                    <?php echo $date->description; ?>

                                                </div>
                                            </div>

                                            <?php if ($__env->exists('case.file_show', ['files' => $date->files, 'type' => 'lobbying'])) echo $__env->make('case.file_show', ['files' => $date->files, 'type' => 'lobbying'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                                        </div>
                                    </div>
                                <?php elseif($date->type == 'putlist'): ?>
                                    <div class="student-meta-box mb-20">
                                        <div class="white-box student-details pt-2 pb-3">
                                            <div class="single-meta">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div class="name">
                                                        <h3 class="mb-0"><?php echo e(formatDate($date->date)); ?> </h3>
                                                    </div>
                                                    <div class="value">
                                                        <?php if(permissionCheck('case.index') and $date->date >= date('Y-m-d')): ?>
                                                            <a style="cursor: pointer;"

                                                               href="<?php echo e(route('date.send_mail', ['case' => $model->id, 'date' => $date->id])); ?>"
                                                               class="primary-btn small fix-gr-bg"><?php echo e(__('case.Send Mail')); ?></a>
                                                        <?php endif; ?>
                                                        <?php if(permissionCheck('putlist.edit')): ?>
                                                            <span style="cursor: pointer;"
                                                                  data-container="file_modal"
                                                                  data-href="<?php echo e(route('file.create', ['case' => $model->id, 'date' => $date->id])); ?>"
                                                                  class="primary-btn small fix-gr-bg btn-modal"><?php echo e(__('case.Add File')); ?></span>
                                                        <?php endif; ?>
                                                        <?php if(permissionCheck('putlist.edit')): ?>
                                                            <a href="<?php echo e(route('putlist.edit', [$date->id, 'case' => $model->id])); ?>"
                                                               class="primary-btn small fix-gr-bg"><?php echo e(__('common.Edit')); ?></a>
                                                        <?php endif; ?>
                                                        <?php if(permissionCheck('putlist.destroy')): ?>
                                                            <span style="cursor: pointer;"
                                                                  data-url="<?php echo e(route('putlist.destroy', $date->id)); ?>"
                                                                  id="delete_item"
                                                                  class="primary-btn small fix-gr-bg"><?php echo e(__('case.Delete')); ?></span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="single-meta">
                                                <div class="d-flex">
                                                    <div class="name mr-1">
                                                        <?php echo e(__('case.Case Type')); ?> :
                                                    </div>
                                                    <div class="value">
                                                        <?php echo e(__('case.Put up Date')); ?>

                                                    </div>
                                                </div>
                                            </div>

                                            <?php if(moduleStatusCheck('CustomField') and $date->customFields): ?>
                                                <?php if ($__env->exists('customfield::details.show', ['customFields' => $date->customFields, 'file' => 'single_meta'])) echo $__env->make('customfield::details.show', ['customFields' => $date->customFields, 'file' => 'single_meta'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php endif; ?>

                                            <div class="single-meta">
                                                <div class="text-left">
                                                    <?php echo $date->description; ?>

                                                </div>
                                            </div>
                                            <?php if ($__env->exists('case.file_show', ['files' => $date->files, 'type' =>'putlist'])) echo $__env->make('case.file_show', ['files' => $date->files, 'type' =>'putlist'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                        </div>
                                    </div>
                                <?php elseif($date->type == 'close'): ?>
                                    <div class="student-meta-box mb-20">
                                        <div class="white-box student-details pt-2 pb-3">
                                            <div class="single-meta">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div class="name">
                                                        <h3 class="mb-0"><?php echo e(formatDate($date->date)); ?> </h3>
                                                    </div>
                                                    <div class="value">
                                                        <?php if(permissionCheck('case.index') and $date->date >= date('Y-m-d')): ?>
                                                            <a style="cursor: pointer;"

                                                               href="<?php echo e(route('date.send_mail', ['case' => $model->id, 'date' => $date->id])); ?>"
                                                               class="primary-btn small fix-gr-bg"><?php echo e(__('case.Send Mail')); ?></a>
                                                        <?php endif; ?>
                                                        <?php if(permissionCheck('date.edit')): ?>
                                                            <span style="cursor: pointer;"
                                                                  data-container="file_modal"
                                                                  data-href="<?php echo e(route('file.create', ['case' => $model->id, 'date' => $date->id])); ?>"
                                                                  class="primary-btn small fix-gr-bg btn-modal"><?php echo e(__('case.Add File')); ?></span>
                                                        <?php endif; ?>

                                                        <?php if(permissionCheck('date.destroy')): ?>
                                                            <span style="cursor: pointer;"
                                                                  data-url="<?php echo e(route('date.destroy', $date->id)); ?>"
                                                                  id="delete_item"
                                                                  class="primary-btn small fix-gr-bg"><?php echo e(__('case.Delete')); ?></span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="single-meta">
                                                <div class="d-flex">
                                                    <div class="name mr-1">
                                                        <?php echo e(__('case.Case Type')); ?> :
                                                    </div>
                                                    <div class="value">
                                                        <?php echo e(__('case.Closed case')); ?>

                                                    </div>
                                                </div>
                                            </div>

                                            <?php if(moduleStatusCheck('CustomField') and $date->customFields): ?>
                                                <?php if ($__env->exists('customfield::details.show', ['customFields' => $date->customFields, 'file' => 'single_meta'])) echo $__env->make('customfield::details.show', ['customFields' => $date->customFields, 'file' => 'single_meta'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php endif; ?>

                                            <div class="single-meta">
                                                <div class="text-left">
                                                    <?php echo $date->description; ?>

                                                </div>
                                            </div>
                                            <?php if ($__env->exists('case.file_show', ['files' => $date->files, 'type' => 'date'])) echo $__env->make('case.file_show', ['files' => $date->files, 'type' => 'date'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                                        </div>
                                    </div>
                                <?php elseif($date->type == 'reopen'): ?>
                                    <div class="student-meta-box mb-20">
                                        <div class="white-box student-details pt-2 pb-3">
                                            <div class="single-meta">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div class="name">
                                                        <h3 class="mb-0"><?php echo e(formatDate($date->date)); ?> </h3>
                                                    </div>
                                                    <div class="value">
                                                        <?php if(permissionCheck('case.index') and $date->date >= date('Y-m-d')): ?>
                                                            <a style="cursor: pointer;"

                                                               href="<?php echo e(route('date.send_mail', ['case' => $model->id, 'date' => $date->id])); ?>"
                                                               class="primary-btn small fix-gr-bg"><?php echo e(__('case.Send Mail')); ?></a>
                                                        <?php endif; ?>
                                                        <?php if(permissionCheck('date.edit')): ?>
                                                            <span style="cursor: pointer;"
                                                                  data-container="file_modal"
                                                                  data-href="<?php echo e(route('file.create', ['case' => $model->id, 'date' => $date->id])); ?>"
                                                                  class="primary-btn small fix-gr-bg btn-modal"><?php echo e(__('case.Add File')); ?></span>
                                                        <?php endif; ?>

                                                        <?php if(permissionCheck('date.destroy')): ?>
                                                            <span style="cursor: pointer;"
                                                                  data-url="<?php echo e(route('date.destroy', $date->id)); ?>"
                                                                  id="delete_item"
                                                                  class="primary-btn small fix-gr-bg"><?php echo e(__('case.Delete')); ?></span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="single-meta">
                                                <div class="d-flex">
                                                    <div class="name mr-1">
                                                        <?php echo e(__('case.Case Type')); ?> :
                                                    </div>
                                                    <div class="value">
                                                        <?php echo e(__('case.Re-open Case')); ?>

                                                    </div>
                                                </div>
                                            </div>

                                            <?php if(moduleStatusCheck('CustomField') and $date->customFields): ?>
                                                <?php if ($__env->exists('customfield::details.show', ['customFields' => $date->customFields, 'file' => 'single_meta'])) echo $__env->make('customfield::details.show', ['customFields' => $date->customFields, 'file' => 'single_meta'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php endif; ?>

                                            <div class="single-meta">
                                                <div class="text-left">
                                                    <?php echo $date->description; ?>

                                                </div>
                                            </div>
                                            <?php if ($__env->exists('case.file_show', ['files' => $date->files, 'type' => 'date'])) echo $__env->make('case.file_show', ['files' => $date->files, 'type' => 'date'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                        </div>
                                    </div>
                                <?php elseif($date->type == 'judgement'): ?>
                                    <div class="student-meta-box mb-20">
                                        <div class="white-box student-details pt-2 pb-3">
                                            <div class="single-meta">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div class="name">
                                                        <h3 class="mb-0"><?php echo e(formatDate($date->date)); ?> </h3>
                                                    </div>
                                                    <div class="value">
                                                        <?php if(permissionCheck('case.index') and $date->date >= date('Y-m-d')): ?>
                                                            <a style="cursor: pointer;"

                                                               href="<?php echo e(route('date.send_mail', ['case' => $model->id, 'date' => $date->id])); ?>"
                                                               class="primary-btn small fix-gr-bg"><?php echo e(__('case.Send Mail')); ?></a>
                                                        <?php endif; ?>
                                                        <?php if(permissionCheck('judgement.edit')): ?>
                                                            <span style="cursor: pointer;"
                                                                  data-container="file_modal"
                                                                  data-href="<?php echo e(route('file.create', ['case' => $model->id, 'date' => $date->id])); ?>"
                                                                  class="primary-btn small fix-gr-bg btn-modal"><?php echo e(__('case.Add File')); ?></span>
                                                        <?php endif; ?>
                                                        <?php if(permissionCheck('judgement.edit')): ?>
                                                            <a href="<?php echo e(route('judgement.edit', [$date->id, 'case' => $model->id])); ?>"
                                                               class="primary-btn small fix-gr-bg"><?php echo e(__('common.Edit')); ?></a>
                                                        <?php endif; ?>
                                                        <?php if(permissionCheck('judgement.destroy')): ?>
                                                            <span style="cursor: pointer;"
                                                                  data-url="<?php echo e(route('judgement.destroy', $date->id)); ?>"
                                                                  id="delete_item"
                                                                  class="primary-btn small fix-gr-bg"><?php echo e(__('case.Delete')); ?></span>
                                                        <?php endif; ?>

                                                    </div>
                                                </div>
                                            </div>

                                            <div class="single-meta">
                                                <div class="d-flex">
                                                    <div class="name mr-1">
                                                        <?php echo e(__('case.Case Type')); ?> :
                                                    </div>
                                                    <div class="value">
                                                        <?php echo e(__('case.Judgement Case')); ?>

                                                    </div>
                                                </div>
                                            </div>

                                            <?php if(moduleStatusCheck('CustomField') and $date->customFields): ?>
                                                <?php if ($__env->exists('customfield::details.show', ['customFields' => $date->customFields, 'file' => 'single_meta'])) echo $__env->make('customfield::details.show', ['customFields' => $date->customFields, 'file' => 'single_meta'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php endif; ?>

                                            <div class="single-meta">
                                                <div class="text-left">
                                                    <?php echo $date->description; ?>

                                                </div>
                                            </div>

                                            <?php if ($__env->exists('case.file_show', ['files' => $date->files, 'type' => 'judgement' ])) echo $__env->make('case.file_show', ['files' => $date->files, 'type' => 'judgement' ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                        </div>
                                    </div>

                                <?php elseif($date->type == 'court_change'): ?>
                                    <div class="student-meta-box mb-20">
                                        <div class="white-box student-details pt-2 pb-3">
                                            <div class="single-meta">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div class="name">
                                                        <h3 class="mb-0"><?php echo e(formatDate($date->date)); ?> </h3>
                                                    </div>
                                                    <div class="value">
                                                        <?php if(permissionCheck('date.edit')): ?>
                                                            <span style="cursor: pointer;"
                                                                  data-container="file_modal"
                                                                  data-href="<?php echo e(route('file.create', ['case' => $model->id, 'date' => $date->id])); ?>"
                                                                  class="primary-btn small fix-gr-bg btn-modal"><?php echo e(__('case.Add File')); ?></span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="single-meta">
                                                <div class="d-flex">
                                                    <div class="name mr-1">
                                                        <?php echo e(__('case.Case Type')); ?> :
                                                    </div>
                                                    <div class="value">
                                                        <?php echo e(__('case.Court Change')); ?>

                                                    </div>
                                                </div>
                                            </div>

                                            <div class="single-meta">
                                                <div class="text-left">
                                                    <?php echo $date->description; ?>

                                                </div>
                                            </div>

                                            <?php if ($__env->exists('case.file_show', ['files' => $date->files, 'type' => 'date'])) echo $__env->make('case.file_show', ['files' => $date->files, 'type' => 'date'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                        </div>
                                    </div>

                                <?php else: ?>

                                    <div class="student-meta-box mb-20">
                                        <div class="white-box student-details pt-2 pb-3">
                                            <div class="single-meta">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div class="name mr-1">
                                                        <h3 class="mb-0"><?php echo e(formatDate($date->date)); ?> </h3>
                                                    </div>
                                                    <div class="value">
                                                        <?php if(permissionCheck('case.index') and $date->date >= date('Y-m-d')): ?>
                                                            <a style="cursor: pointer;"

                                                               href="<?php echo e(route('date.send_mail', ['case' => $model->id, 'date' => $date->id])); ?>"
                                                               class="primary-btn small fix-gr-bg"><?php echo e(__('case.Send Mail')); ?></a>
                                                        <?php endif; ?>
                                                        <?php if(permissionCheck('date.edit')): ?>
                                                            <span style="cursor: pointer;"
                                                                  data-container="file_modal"
                                                                  data-href="<?php echo e(route('file.create', ['case' => $model->id, 'date' => $date->id])); ?>"
                                                                  class="primary-btn small fix-gr-bg btn-modal"><?php echo e(__('case.Add File')); ?></span>
                                                        <?php endif; ?>
                                                        <?php if(permissionCheck('date.edit')): ?>
                                                            <a href="<?php echo e(route('date.edit', [$date->id, 'case' => $model->id])); ?>"
                                                               class="primary-btn small fix-gr-bg"><?php echo e(__('common.Edit')); ?></a>
                                                        <?php endif; ?>
                                                        <?php if(permissionCheck('date.destroy')): ?>
                                                            <span style="cursor: pointer;"
                                                                  data-url="<?php echo e(route('date.destroy', $date->id)); ?>"
                                                                  id="delete_item"
                                                                  class="primary-btn small fix-gr-bg"><?php echo e(__('case.Delete')); ?></span>
                                                        <?php endif; ?>

                                                    </div>
                                                </div>
                                            </div>

                                            <div class="single-meta">
                                                <div class="d-flex align-items-center">
                                                    <div class="name mr-1">
                                                        <?php echo e(__('case.Case Type')); ?> :
                                                    </div>
                                                    <div class="value">
                                                        <?php echo e(@$date->case_stage->name); ?>

                                                    </div>
                                                </div>
                                            </div>

                                            <?php if(moduleStatusCheck('CustomField') and $date->customFields): ?>
                                                <?php if ($__env->exists('customfield::details.show', ['customFields' => $date->customFields, 'file' => 'single_meta'])) echo $__env->make('customfield::details.show', ['customFields' => $date->customFields, 'file' => 'single_meta'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php endif; ?>

                                            <div class="single-meta">
                                                <div class="text-left">
                                                    <?php echo $date->description; ?>

                                                </div>
                                            </div>

                                            <?php if ($__env->exists('case.file_show', ['files' => $date->files, 'type' => 'date'])) echo $__env->make('case.file_show', ['files' => $date->files, 'type' => 'date'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                                        </div>
                                    </div>
                                <?php endif; ?>


                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <div class="student-meta-box mb-20">
                                <div class="white-box student-details pt-2 pb-3">
                                    <div class="single-meta">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div class="name mr-1">

                                            </div>
                                            <div class="value">

                                            </div>
                                        </div>
                                    </div>

                                    <div class="single-meta">
                                        <div class="d-flex align-items-center">
                                            <div class="name mr-1">
                                                <?php echo e(__('case.Description')); ?> :
                                            </div>
                                            <div class="value">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="single-meta">
                                        <div class="text-left">
                                            <?php echo $model->description; ?>

                                        </div>
                                    </div>

                                    <?php if ($__env->exists('case.file_show', ['files' => $model->files, 'type' => 'case'])) echo $__env->make('case.file_show', ['files' => $model->files, 'type' => 'case'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                                </div>
                            </div>

                        </div>

                        <?php if(moduleStatusCheck('Finance')): ?>
                            <div class="col-lg-12">
                                <div class="student-meta-box mb-20" $invoice>
                                    <div class="white-box student-details pt-2 pb-3">

                                        <div class="single-meta">
                                            <div class="d-flex align-items-center">
                                                <div class="name mr-1">
                                                    <h3><?php echo e(__('finance.Invoices')); ?> :</h3>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="single-meta">
                                            <div class="">
                                                <table class="table table-sm">
                                                    <thead>
                                                    <tr>
                                                        <th scope="col"><?php echo e(__('common.SL')); ?></th>
                                                        <th><?php echo e(__('finance.Date')); ?></th>
                                                        <th><?php echo e(__('finance.Invoice No')); ?></th>
                                                        <th><?php echo e(__('finance.Client')); ?></th>
                                                        <th><?php echo e(__('finance.Total Amount')); ?></th>
                                                        <th><?php echo e(__('finance.Paid')); ?></th>
                                                        <th><?php echo e(__('finance.Due')); ?></th>
                                                        <th class="d-print-none text-center"><?php echo e(__('common.Actions')); ?></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php $__currentLoopData = $model->invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td><?php echo e($loop->index + 1); ?></td>
                                                            <td>
                                                                <?php echo e(formatDate($invoice->transaction_date)); ?>

                                                            </td>
                                                            <td>
                                                                <a href="<?php echo e(route('invoice.incomes.show', $invoice->id)); ?>"
                                                                   target="_blank"> <?php echo e($invoice->invoice_no); ?> </a>
                                                            </td>
                                                            <td>
                                                                <a href="<?php echo e(route('client.show', $invoice->clientable_id)); ?>"
                                                                   target="_blank"><?php echo e($invoice->clientable->name); ?> </a>
                                                                <?php if($invoice->case): ?>
                                                                    (<?php echo e($invoice->case->title); ?>)
                                                                <?php endif; ?>
                                                            </td>
                                                            <td><?php echo e(amountFormat($invoice->grand_total)); ?></td>
                                                            <td><?php echo e(amountFormat($invoice->paid)); ?></td>
                                                            <td><?php echo e(amountFormat($invoice->due)); ?></td>


                                                            <td class="d-print-none text-center">

                                                                <div class="dropdown CRM_dropdown">
                                                                    <button class="btn btn-secondary dropdown-toggle"
                                                                            type="button"
                                                                            id="dropdownMenu2" data-toggle="dropdown"
                                                                            aria-haspopup="true"
                                                                            aria-expanded="false">
                                                                        <?php echo e(__('common.Select')); ?>

                                                                    </button>
                                                                    <div class="dropdown-menu dropdown-menu-right"
                                                                         aria-labelledby="dropdownMenu2">
                                                                        <?php if(permissionCheck('invoice.incomes.show')): ?>
                                                                            <a href="<?php echo e(route('invoice.incomes.show', $invoice->id)); ?>"
                                                                               class="dropdown-item edit_brand"><?php echo e(__('common.Show')); ?></a>
                                                                        <?php endif; ?>

                                                                        <?php if(permissionCheck('invoice.incomes.show')): ?>
                                                                            <a
                                                                                class="dropdown-item edit_brand print_window"
                                                                                href="<?php echo e(route('invoice.print',$invoice->id)); ?>"><?php echo e(__('common.Print')); ?></a>
                                                                        <?php endif; ?>

                                                                        <?php if($invoice->due >  0 and permissionCheck('invoice.payment.add')): ?>
                                                                            <a class="dropdown-item edit_brand btn-modal"
                                                                               data-container="payment_modal"
                                                                               href="<?php echo e(route('invoice.payment.add',$invoice->id)); ?>"><?php echo e(__('finance.Add Payment')); ?></a>
                                                                        <?php endif; ?>

                                                                        <?php if(permissionCheck('invoice.incomes.edit')): ?>
                                                                            <a href="<?php echo e(route('invoice.incomes.edit', $invoice->id)); ?>"
                                                                               class="dropdown-item edit_brand"><?php echo e(__('common.Edit')); ?></a>
                                                                        <?php endif; ?>
                                                                        <?php if(permissionCheck('invoice.incomes.destroy')): ?>
                                                                            <span id="delete_item"
                                                                                  data-id="<?php echo e($invoice->id); ?>"
                                                                                  data-url="<?php echo e(route('invoice.incomes.destroy', $invoice->id)); ?>"
                                                                                  class="dropdown-item"><i
                                                                                    class="icon-trash"></i>
                                                                        <?php echo e(__('common.Delete')); ?> </span>
                                                                        <?php endif; ?>


                                                                    </div>
                                                                </div>


                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="student-meta-box mb-20">
                                    <div class="white-box student-details pt-2 pb-3">

                                        <div class="single-meta">
                                            <div class="d-flex align-items-center">
                                                <div class="name mr-1">
                                                    <h3><?php echo e(__('finance.Transactions')); ?> :</h3>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="single-meta">
                                            <div class="">
                                                <?php
                                                    $model->invoice_type = 'income'
                                                ?>
                                                <?php if ($__env->exists('finance::invoice.payment_table')) echo $__env->make('finance::invoice.payment_table', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>


                <div class="col-lg-4 mt-25">
                    <div class="student-meta-box sticky-details">
                        <div class="white-box student-details pt-3">
                            <div class="single-meta">
                                <h3 class="mb-0"><?php echo e(__('case.Details')); ?> </h3>
                            </div>
                            <div class="single-meta mt-10">
                                <div class="d-flex justify-content-between">
                                    <div class="name">
                                        <?php echo e(__('case.Case No.')); ?>:
                                    </div>
                                    <div class="value">
                                        <?php echo e($model->case_category? $model->case_category->name : ''); ?>

                                        - <?php echo e($model->case_no); ?>

                                    </div>
                                </div>
                            </div>

                            <div class="single-meta">
                                <div class="d-flex justify-content-between">
                                    <div class="name">
                                        <?php echo e(__('case.Category')); ?>:
                                    </div>
                                    <div class="value">
                                        <?php if($model->case_category): ?>
                                            <a href="<?php echo e(route('category.case.show', $model->case_category_id)); ?>">
                                                <?php echo e($model->case_category? $model->case_category->name : ''); ?>

                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="single-meta">
                                <div class="d-flex justify-content-between">
                                    <div class="name">
                                        <?php echo e(__('case.File No')); ?>:
                                    </div>
                                    <div class="value">
                                        <?php echo e($model->file_no); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="single-meta">
                                <div class="d-flex justify-content-between">
                                    <div class="name">
                                        <?php echo e(__('case.Reference')); ?>:
                                    </div>
                                    <div class="value">
                                        <?php echo e($model->ref_name); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="single-meta">
                                <div class="d-flex justify-content-between">
                                    <div class="name">
                                        <?php echo e(__('case.Reference Mobile')); ?>:
                                    </div>
                                    <div class="value">
                                        <?php echo e($model->ref_mobile); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="single-meta">
                                <div class="d-flex justify-content-between">
                                    <div class="name">
                                        <?php echo e(__('case.Next Hearing Date')); ?>:
                                    </div>
                                    <div class="value">
                                        <?php echo e(formatDate($model->hearing_date)); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="single-meta">
                                <div class="d-flex justify-content-between">
                                    <div class="name">
                                        <?php echo e(__('case.Filing Date')); ?>:
                                    </div>
                                    <div class="value">
                                        <?php echo e(formatDate($model->filling_date)); ?>

                                    </div>
                                </div>
                            </div>


                            <div class="single-meta">
                                <div class="d-flex justify-content-between">
                                    <div class="name">
                                        <?php echo e(__('case.Case Stage')); ?>:
                                    </div>
                                    <div class="value">
                                        <?php echo $model->case_stage ? '<a
                                            href="'.route('master.stage.show', $model->stage_id).'">'. $model->case_stage->name
                                            .'</a>' : ''; ?>

                                    </div>
                                </div>
                            </div>

                            <div class="single-meta">
                                <div class="d-flex justify-content-between">
                                    <div class="name">
                                        <?php echo e(__('case.Case Charge')); ?>:
                                    </div>
                                    <div class="value">
                                        <?php echo e(amountFormat($model->case_charge)); ?>

                                    </div>
                                </div>
                            </div>

                            <div class="single-meta mt-10">
                                <h3 class="mb-30"><?php echo e(__('case.Client')); ?> </h3>
                            </div>


                            <?php if($model->client == 'Plaintiff' and $model->plaintiff_client): ?>
                                <div class="single-meta">
                                    <div class="d-flex justify-content-between">
                                        <div class="name">
                                            <?php echo e(__('case.Name')); ?>:
                                        </div>
                                        <div class="value">
                                            <a href="<?php echo e(route('client.show', $model->plaintiff_client->id)); ?>">
                                                <?php echo e($model->plaintiff_client->name); ?>

                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="single-meta">
                                    <div class="d-flex justify-content-between">
                                        <div class="name">
                                            <?php echo e(__('case.Mobile')); ?>:
                                        </div>
                                        <div class="value">
                                            <?php echo e($model->plaintiff_client->mobile); ?>

                                        </div>
                                    </div>
                                </div>
                                <div class="single-meta">
                                    <div class="d-flex justify-content-between">
                                        <div class="name">
                                            <?php echo e(__('case.Email')); ?>:
                                        </div>
                                        <div class="value">
                                            <?php echo e($model->plaintiff_client->email); ?>

                                        </div>
                                    </div>
                                </div>
                                <div class="single-meta">
                                    <div class="d-flex justify-content-between">
                                        <div class="name">
                                            <?php echo e(__('case.Address')); ?>

                                        </div>
                                        <div class="value">
                                            <?php echo e($model->plaintiff_client->address); ?>

                                        </div>
                                    </div>
                                </div>
                                <div class="single-meta">
                                    <div class="d-flex justify-content-between">
                                        <div class="name">
                                            <?php echo e(__('case.Location')); ?>

                                        </div>
                                        <div class="value">
                                            <?php echo e($model->plaintiff_client->state ? $model->plaintiff_client->state->name.',' : ''); ?>

                                            <?php echo e($model->plaintiff_client->city ? $model->plaintiff_client->city->name : ''); ?>

                                        </div>
                                    </div>
                                </div>

                            <?php elseif($model->client == 'Opposite' and $model->opposite_client): ?>

                                <div class="single-meta">
                                    <div class="d-flex justify-content-between">
                                        <div class="name">
                                            <?php echo e(__('case.Name')); ?>:
                                        </div>
                                        <div class="value">
                                            <a href="<?php echo e(route('client.show', $model->opposite_client->id)); ?>">
                                                <?php echo e($model->opposite_client->name); ?>

                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="single-meta">
                                    <div class="d-flex justify-content-between">
                                        <div class="name">
                                            <?php echo e(__('case.Mobile')); ?>:
                                        </div>
                                        <div class="value">
                                            <?php echo e($model->opposite_client->mobile); ?>

                                        </div>
                                    </div>
                                </div>
                                <div class="single-meta">
                                    <div class="d-flex justify-content-between">
                                        <div class="name">
                                            <?php echo e(__('case.Email')); ?>:
                                        </div>
                                        <div class="value">
                                            <?php echo e($model->opposite_client->email); ?>

                                        </div>
                                    </div>
                                </div>
                                <div class="single-meta">
                                    <div class="d-flex justify-content-between">
                                        <div class="name">
                                            <?php echo e(__('case.Address')); ?>

                                        </div>
                                        <div class="value">
                                            <?php echo e($model->opposite_client->address); ?>

                                        </div>
                                    </div>
                                </div>
                                <div class="single-meta">
                                    <div class="d-flex justify-content-between">
                                        <div class="name">
                                            <?php echo e(__('case.Location')); ?>

                                        </div>
                                        <div class="value">
                                            <?php echo e($model->opposite_client->district ? ', '. $model->opposite_client->district->name : ''); ?>

                                            <?php echo e($model->opposite_client->division ? ', '. $model->opposite_client->division->name : ''); ?>

                                        </div>
                                    </div>
                                </div>

                            <?php endif; ?>


                            <div class="single-meta mt-10">
                                <div class="d-flex justify-content-between">

                                    <div class="name">
                                        <h3 class="mb-30"><?php echo e(__('case.Court')); ?> </h3>
                                    </div>
                                    <div class="value">
                                        <?php if(moduleStatusCheck('EmailtoCL') and $model->court): ?>

                                            <a style="cursor: pointer;" data-toggle="tooltip"
                                               title="<?php echo e(__('case.Send Mail To Court')); ?>"
                                               href="<?php echo e(route('send_email_to_court', [$model->id])); ?>"
                                               class="primary-btn small fix-gr-bg icon-only"><i
                                                    class="ti-email"></i></a>
                                        <?php endif; ?>

                                        <a href="<?php echo e(route('case.court.change', $model->id)); ?>"
                                           class="primary-btn small fix-gr-bg">
                                            <?php echo e(__('case.Court Change')); ?>

                                        </a>

                                    </div>
                                </div>
                            </div>

                            <?php if($model->court): ?>
                                <div class="single-meta">
                                    <div class="d-flex justify-content-between">
                                        <div class="name">
                                            <?php echo e(__('case.Name')); ?>

                                        </div>
                                        <div class="value">
                                            <a href="<?php echo e(route('master.court.show', $model->court_id)); ?>">
                                                <?php echo e($model->court->name); ?> </a>
                                        </div>
                                    </div>
                                </div>
                                <?php if(moduleStatusCheck('EmailtoCL')): ?>
                                    <div class="single-meta">
                                        <div class="d-flex justify-content-between">
                                            <div class="name">
                                                <?php echo e(__('case.Name')); ?>

                                            </div>
                                            <div class="value">
                                                <a title="<?php echo e(__('case.Send Mail To Court')); ?>" data-toggle="tooltip"
                                                   href="<?php echo e(route('send_email_to_court', [$model->id])); ?>">
                                                    <?php echo e($model->court->email); ?> </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <div class="single-meta">
                                    <div class="d-flex justify-content-between">
                                        <div class="name">
                                            <?php echo e(__('case.Category')); ?>

                                        </div>
                                        <div class="value">
                                            <a href="<?php echo e(route('category.court.show', $model->court_category_id)); ?>">
                                                <?php echo e($model->court->court_category ? $model->court->court_category->name : ''); ?> </a>
                                        </div>
                                    </div>
                                </div>

                                <div class="single-meta">
                                    <div class="d-flex justify-content-between">
                                        <div class="name">
                                            <?php echo e(__('case.Room No')); ?>

                                        </div>
                                        <div class="value">
                                            <?php echo e($model->court->room_number); ?>

                                        </div>
                                    </div>
                                </div>
                                <div class="single-meta">
                                    <div class="d-flex justify-content-between">
                                        <div class="name">
                                            <?php echo e(__('case.Address')); ?>

                                        </div>
                                        <div class="value">
                                            <?php echo e($model->court->location); ?>

                                        </div>
                                    </div>
                                </div>
                                <div class="single-meta">
                                    <div class="d-flex justify-content-between">
                                        <div class="name">
                                            <?php echo e(__('case.Location')); ?>

                                        </div>
                                        <div class="value">
                                            <?php echo e($model->court->state ? $model->court->state->name.',' : ''); ?>

                                            <?php echo e($model->court->city ? $model->court->city->name : ''); ?>

                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <div class="single-meta mt-10">
                                <h3 class="mb-30"><?php echo e(__('case.Acts')); ?> </h3>
                            </div>

                            <div class="single-meta mt-10">
                                <?php if($model->acts): ?>
                                    <?php $__currentLoopData = $model->acts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $act): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo e($act->act ? $act->act->name .', ': ''); ?>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>

                            <div class="single-meta mt-10">
                                <h3 class="mb-2"><?php echo e(__('case.Opposite Lawyer')); ?> <a
                                        class="primary-btn small fix-gr-bg icon-only "
                                        href="<?php echo e(route('case.add_lawyer', $model->id)); ?>"><i class="ti-plus"
                                                                                             data-toggle="tooltip"
                                                                                             title="<?php echo e(__('common.add_lawyer_to_case')); ?>"></i></a>
                                </h3>
                            </div>
                            <?php if($model->lawyers): ?>
                                <?php $__currentLoopData = $model->lawyers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lawyer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="single-meta">
                                        <div class="d-flex justify-content-between">

                                            <?php if($lawyer->pivot->deleted_at): ?>
                                                <del data-toggle="tooltip"
                                                     title="<?php echo e(__('common.removed_at'). ' '.formatDate($lawyer->pivot->deleted_at)); ?>">
                                                    <?php endif; ?>
                                                    <div class="name"
                                                         <?php if(!$lawyer->pivot->deleted_at): ?> data-toggle="tooltip"
                                                         title="<?php echo e(__('common.added_on'). ' '.formatDate($lawyer->pivot->created_at)); ?>" <?php endif; ?>>
                                                        <a href="<?php echo e(route('lawyer.show', $lawyer->id)); ?>"> <?php echo e($lawyer->name); ?> </a>
                                                    </div>
                                                    <?php if(!$lawyer->pivot->deleted_at): ?>
                                                        <?php if(moduleStatusCheck('EmailtoCL')): ?>
                                                            <div class="value">
                                                                <a style="cursor: pointer;" data-toggle="tooltip"
                                                                   title="<?php echo e(__('case.Send Mail To Lawyer')); ?>"
                                                                   href="<?php echo e(route('send_email_to_lawyer', [$model->id, $lawyer->id])); ?>"
                                                                   class="primary-btn small fix-gr-bg icon-only"><i
                                                                        class="ti-email"></i></a>
                                                                <?php endif; ?>
                                                                <span style="cursor: pointer;" data-toggle="tooltip"
                                                                      title="<?php echo e(__('common.remove')); ?>"
                                                                      data-url="<?php echo e(route('case.remove_lawyer', [$model->id, $lawyer->id])); ?>"
                                                                      id="delete_item"
                                                                      class="primary-btn small fix-gr-bg icon-only"><i
                                                                        class="ti-trash"></i></span>
                                                            </div>
                                                        <?php endif; ?>

                                                        <?php if($lawyer->pivot->deleted_at): ?>
                                                </del>
                                            <?php endif; ?>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>

                                        <?php if(moduleStatusCheck('CustomField') and $model->customFields): ?>
                                            <?php if ($__env->exists('customfield::details.show', ['customFields' => $model->customFields, 'file' => 'single_meta'])) echo $__env->make('customfield::details.show', ['customFields' => $model->customFields, 'file' => 'single_meta'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php endif; ?>

                                        <div class="single-meta mt-10">

                                        </div>


                                    </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>
    <div class="modal fade animated file_modal infix_biz_modal" id="remote_modal" tabindex="-1" role="dialog"
         aria-labelledby="remote_modal_label" aria-hidden="true" data-backdrop="static">
    </div>

    <?php if(moduleStatusCheck('Finance')): ?>
        <div class="modal fade animated payment_modal infix_biz_modal" id="remote_modal" tabindex="-1" role="dialog"
             aria-labelledby="remote_modal_label" aria-hidden="true" data-backdrop="static">
        </div>
    <?php endif; ?>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('admin.scripts'); ?>
    <script>


    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', ['title' => __('case.Case Details')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64-7.4\www\Infix Advocate V1.1.1\resources\views/case/show.blade.php ENDPATH**/ ?>