<div class="modal-dialog  modal-dialog-centered modal-lg">
    <div class="modal-content">


        <div class="modal-header">
            <h4 class="modal-title"><?php echo e(__('court.New Court')); ?></h4>
            <button type="button" class="close " data-dismiss="modal">
                <i class="ti-close "></i>
            </button>
        </div>

        <div class="modal-body">
            <div class="row">
                <div class="col-12">
                    <?php echo Form::open(['route' => 'master.court.store', 'class' => 'form-validate-jquery', 'id' => 'court_quick_add_form', 'files' => false, 'method' => 'POST']); ?>

                    <input type="hidden" name="quick_add" value="1">

                    <div class="row">
                        <div class="primary_input col-md-4">
                            <?php echo e(Form::label('country_id', __('court.Country'))); ?>

                            <?php echo e(Form::select('country_id', $countries, config('configs')->where('key','country_id')->first()->value, ['class' => 'primary_select', 'id' => 'country_id', 'data-placeholder' => __('court.Select country'),  'data-parsley-errors-container' => '#country_id_error'])); ?>

                            <span id="country_id_error"></span>
                        </div>

                        <div class="primary_input col-md-4">
                            <?php echo e(Form::label('state_id', __('court.State'))); ?>

                            <?php echo e(Form::select('state_id', $states, null, ['class' => 'primary_select','id' => 'state_id', 'data-placeholder' => __('court.Select state'), 'data-parsley-errors-container' => '#state_id_error'])); ?>

                            <span id="state_id_error"></span>
                        </div>

                        <div class="primary_input col-md-4">
                            <?php echo e(Form::label('city_id', __('court.City'))); ?>

                            <?php echo e(Form::select('city_id',[''=> __('common.Select State First')], null, ['class' => 'primary_select','id' => 'city_id', 'data-placeholder' => __('court.Select city'), 'data-parsley-errors-container' => '#city_id_error'])); ?>

                            <span id="city_id_error"></span>
                        </div>

                    </div>
                    <div class="row">

                        <div class="primary_input col-md-6">
                            <?php echo e(Form::label('court_category_id', __('court.Court Category'))); ?>

                            <?php echo e(Form::select('court_category_id', $court_categories, $court_category_id, ['class' => 'primary_select', 'data-placeholder' => __('court.Court Category'), 'data-parsley-errors-container' => '#court_category_error', 'disabled'])); ?>

                            <span id="court_category_error"></span>
                        </div>
                        <div class="primary_input col-md-6">
                            <?php echo e(Form::label('location', __('court.Location/ Police Station'))); ?>

                            <?php echo e(Form::text('location', null, ['class' => 'primary_input_field', 'placeholder' => __('court.Location/ Police Station')])); ?>

                        </div>
                    </div>
                    <div class="row">
                        <div class="primary_input col-md-6">
                            <?php echo e(Form::label('name', __('court.Court Name'),['class' => 'required'])); ?>

                            <?php echo e(Form::text('name', null, ['required' => '', 'class' => 'primary_input_field', 'placeholder' => __('court.Court Name')])); ?>

                        </div>
                        <div class="primary_input col-md-6">
                            <?php echo e(Form::label('room_number', __('court.Court Room Number'))); ?>

                            <?php echo e(Form::text('room_number', null, ['class' => 'primary_input_field', 'placeholder' => __('court.Court Room Number')])); ?>

                        </div>
                    </div>
                    <?php if(moduleStatusCheck('EmailtoCL')): ?>
                        <div class="row">

                            <div class="primary_input  col-12">
                                <?php echo e(Form::label('email', __('case.Email'))); ?>

                                <?php echo e(Form::email('email', null, [ 'class' => 'primary_input_field', 'placeholder' => __('case.Email')])); ?>

                            </div>

                        </div>
                    <?php endif; ?>
                    <?php if ($__env->exists('customfield::fields', ['fields' => $fields, 'model' => null])) echo $__env->make('customfield::fields', ['fields' => $fields, 'model' => null], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <div class="primary_input">
                        <?php echo e(Form::label('description', __('court.Description'))); ?>

                        <?php echo e(Form::textarea('description', null, ['class' => 'primary_input_field summernote', 'placeholder' => __('court.Court  Description'), 'rows' => 5, 'maxlength' => 1500, 'data-parsley-errors-container' =>
                        '#description_error' ])); ?>

                        <span id="description_error"></span>
                    </div>

                    <input type="hidden" name="court_category_id" value="<?php echo e($court_category_id); ?>">
                    <div class="text-center mt-3">
                        <button class="primary_btn_large submit" type="submit"><i
                                class="ti-check"></i><?php echo e(__('common.Create')); ?>

                        </button>

                        <button class="primary_btn_large submitting" type="submit" disabled style="display: none;">
                            <i class="ti-check"></i><?php echo e(__('common.Creating') . '...'); ?>

                        </button>
                    </div>
                    <?php echo Form::close(); ?>

                </div>

            </div>
        </div>
    </div>
</div>

    <script>
        _formValidation('#court_quick_add_form', true, 'court_add_modal');
    </script>
<?php /**PATH C:\wamp64-7.4\www\Infix Advocate V1.1.1\resources\views/master/court/create_modal.blade.php ENDPATH**/ ?>